Painted Fences
==============

## Information
--------------

Based on the fence parts of Mobs Redo; created when I needed to make mob fences,
but the biome had no default wood. Mob fences need default wood because they use
that wood's texture; painted fences look the same no matter what wood type they
are made with, and can be converted to mob fences and back. Painted mob fences
have inventory images with upward arrowheads over the fenceposts, to indicate
that their collision boxes are higher.

Painted fences, rails, gates, mob fences and mob fence tops are crafted from any
wood type, or the white mushroom stalk from Ethereal NG, using the usual recipe
plus a dye. Most painted fence items can only be created; mob fences and tops
can be "painted" by combining then with a dye. A single painted fence in the
crafting grid produces a painted mob fence, and vice versa.

Painted fence items can be repainted by combining the item with a dye. The
recipe uses groups, so it is possible to paint an item the same colour it
already was. Repainting is wasteful on dyes, as crafting a painted item uses one
dye for the whole batch, while repainting uses one unit of dye per item.

This mod was tested in Minetest versions 0.4.17.1, 5.3.0 and 5.8.0. For backward
compatibility, fences and rails are registered with a dummy recipe material,
after which the dummy recipe is cleared and the real recipe added; these dummy
recipes may show up in (old versions of) inventory/crafting mods.

Included are 16x16 and 128x128 (to be used with the Hand Painted Pack by
Drummyfish) tiles; they are are supposed to show a "brush strokes" surface, but
this is only really visible in the 128x128 tiles.

Also included: French and German translation files, cobbled together from
default and mobs translations.

![screenshot.png](screenshot.png)

Forum Topic https://forum.minetest.net/viewtopic.php?t=30795

TODO:

- Make compatible with Better Fences (`better_fences`)
- Repaint fence nodes by punching them with dye? (swapping nodes crashes for me)
- Painted mese light posts? (5.4.0 and up)

--------------
## Technical info
--------------

#### Compatibility

Needed for fences and painting:

* default
* dye

Made to work with:

* doors - adds painted gates
* Mobs Redo (`mobs`) - the reason for this mod: adds painted mob fences/tops
* Wider Gates (`gates_long`) - adds wide painted gates
* Ethereal NG (`ethereal`) - makes painted fences from giant mushroom stalks
* Cropocalypse (`cropocalypse`) - adds light blue dye

#### Crafts

* W = "group:wood" (or Ethereal's giant mushroom stalk)
* S = "group:stick"
* D = dye
* I = iron/steel ingot (name depends on mods loaded)
* F = painted fence
* R = painted fencerail
* G = painted gate
* M = (painted or original) mob fence
* T = (painted or original) mob fence top


**[colour] fence**.

Creating:
```
 W S W
 W S W
   D
```
Creating from painted mob fence (colour stays the same):
```
 M
```
Repainting:
```
 F
 D
```
**[colour] fence rail**.

Creating:
```
 W   W
 D
 W   W
```
Repainting:
```
 R
 D
```
**[colour] fence gate**.

Creating:
```
 S W S
 S W S
   D
```
Repainting:
```
 G
 D
```
**[colour] wide fence gate** (if `gates_long` is loaded).

Creating:
```
 I W I
   W
   D
```
Repainting:
```
 G
 D
```
**[colour] mob fence** (if `mobs` is loaded).

Creating:
```
 F (the fence colour acts as dye)
```
(Re)painting:
```
 M
 D
```
**[colour] mob fence top** (if `mobs` is loaded).
```
 W W W
   F (the fence colour acts as dye)
```
(Re)painting:
```
 T
 D
```

--------------
## Changelog
--------------

#### Version 0.2

Doesn't exist yet, but surely the first version will have errors to fix.

#### Version 0.1

Initial Release

--------------
## Credit
--------------

* Code:
    * gates_long.lua copies function gates_long.register_gate from gates_long by
    Sokomine (GPL-3.0-only), because for technical reasons I couldn't call the
    function from my mod, as intended.
* Art:
    * mob_fence_overlay.png: derived from default_fence_overlay.png in the
    Minetest game (celeron55, Perttu Ahola <celeron55@gmail.com> (CC BY-SA 3.0))
    * mob_fence_overlay.png for 128x128 Hand Painted textures: derived from
    default_fence_overlay.png in the Hand Painted Pack by drummyfish (CC0)

--------------
## Licence
--------------

* Code:
    * Licence: EUPL-1.2 Copyright (c) 2024 Clickety
* Art:
    * Licence: EUPL-1.2 Copyright (c) 2024 Clickety

See the [LICENCE.txt](LICENCE.txt) file.
