--[[
The gates_long mod has a public function to add wide gates, but
1. they must be registered as ":gates_long.name" which the function won't let me
do,
2. translation support is not so good,
3. it forces the same recipe as "doors" which won't let me add a dye.
Copying and adapting the function code here gets around these limitations.
]]

-- Get useful values from mod object.
local S       = painted_fences.translate
local dyelist = painted_fences.dyelist

-- For the light blue dye:
local cropo = minetest.get_modpath("cropocalypse")
-- To make painted items from mushroom blocks:
local ethshroom = minetest.get_modpath("ethereal") and "ethereal:mushroom_trunk" or ""


-- Create nodes, recipes per dye.
local function paintgateslong( pcolour, plabel )

	local gnamec  = "gates_long:fence_gate_closed_"..pcolour
	local gnameo  = "gates_long:gate_open_"..pcolour
	local glabel  = plabel .. " Wide Fence Gate"
	local gtex    = { "painted_fences_rail_" .. pcolour .. ".png" }
-- Gates use rail texture.
--BOOKMARK thisis mmore like fence than gate
	local dyename = "dye:" .. pcolour
	if cropo and pcolour == "light_blue" then
		dyename = "cropocalypse:light_blue_dye"
	end

--minetest.log("action", gnamec .. " " .. dyename .. " " .. glabel)

	-- Sokomine's code, adapted:
	-- the closed version contains the string "fence" in its name - thus preventing mobs from jumping over
	minetest.register_node(":" .. gnamec, {
		description = S(glabel),
		drawtype = "nodebox",
		-- top, bottom, side1, side2, inner, outer
		tiles = gtex,
		paramtype = "light",
		paramtype2 = "facedir",
		groups =
			{ snappy=2, choppy=2, oddly_breakable_by_hand=2, paint_gate2=1 },
		node_box = {
			type = "fixed",
			fixed = {
				-- horizontal wood
				{ -0.85, -0.25, -0.02, -0.005, -0.05,  0.02},
				{ -0.85,  0.15, -0.02, -0.005,  0.35,  0.02},

				{  0.005, -0.25, -0.02,  0.85, -0.05,  0.02},
				{  0.005,  0.15, -0.02,  0.85,  0.35,  0.02},

				-- vertical wood
				{ -0.80, -0.05, -0.02, -0.60,  0.15,  0.02},
				{  0.60, -0.05, -0.02,  0.80,  0.15,  0.02},

				{ -0.25, -0.05, -0.02, -0.05,  0.15,  0.02},
				{  0.05, -0.05, -0.02,  0.25,  0.15,  0.02},

				-- locking mechanism (top)
				{ -0.15,  0.32, -0.01,  0.15,  0.38,  0.01},
				-- locking mechanism (bottom)
				{ -0.15, -0.28, -0.01,  0.15, -0.22,  0.01},

				-- hinges for the horizontal wood
				{ -0.91, -0.24, -0.015, -0.84, -0.06,  0.015},
				{ -0.91,  0.16, -0.015, -0.84,  0.34,  0.015},
				{  0.84, -0.24, -0.015,  0.91, -0.06,  0.015},
				{  0.84,  0.16, -0.015,  0.91,  0.34,  0.015},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.85, -0.25, -0.1,  0.85,  0.35,  0.1},
			},
		},
		on_rightclick = function(pos, node, puncher)
			minetest.swap_node(pos,
				{name = gnameo, param2 = node.param2}
			)
		end,
		is_ground_content = false,
	})

	-- the opened version allows cattle to pass (until it autocloses)
	minetest.register_node(":" .. gnameo, {
		description = S(glabel),
		drawtype = "nodebox",
		-- top, bottom, side1, side2, inner, outer
		tiles = gtex,
		paramtype = "light",
		paramtype2 = "facedir",
		drop = gnamec,
		groups =
			{ snappy=2, choppy=2, oddly_breakable_by_hand=2,
			not_in_creative_inventory=1, paint_gate2=1 },
	-- Adding paint_gate2 makes (undoable) repaint recipe appear for open gate.
	-- Sad, but default gates have the same issue.
		node_box = {
			type = "fixed",
			fixed = {
				-- horizontal wood
				{ -0.87, -0.25, -0.02, -0.83,  -0.05,  0.85},
				{ -0.87,  0.15, -0.02, -0.83,   0.35,  0.85},
				{  0.83, -0.25, -0.02,  0.87, -0.05,  0.85},
				{  0.83,  0.15, -0.02,  0.87,  0.35,  0.85},

				-- vertical wood
				{ -0.87, -0.05,  0.80, -0.83,  0.15,  0.60},
				{ -0.87, -0.05,  0.25, -0.83,  0.15,  0.05},
				{  0.83, -0.05,  0.80,  0.87,  0.15,  0.60},
				{  0.83, -0.05,  0.25,  0.87,  0.15,  0.05},

				-- locking mechanism (top) - they are only on one side
				{ -0.86,  0.32,  0.53, -0.84,  0.38,  0.83},
				-- locking mechanism (bottom) - these as well
				{ -0.86, -0.28,  0.53, -0.84, -0.22,  0.83},

				-- hinges for the horizontal wood (they remain the same)
				{ -0.91, -0.24, -0.015, -0.84, -0.06,  0.015},
				{ -0.91,  0.16, -0.015, -0.84,  0.34,  0.015},
				{  0.84, -0.24, -0.015,  0.91, -0.06,  0.015},
				{  0.84,  0.16, -0.015,  0.91,  0.34,  0.015},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{ -0.90, -0.25, 0,  0.90,  0.35,  0.50},
			},
		},
		on_rightclick = function(pos, node, puncher)
			minetest.swap_node(pos,
				{name = gnamec, param2 = node.param2}
			)
		end,
		is_ground_content = false,
	})

	-- automaticly close the gates again to prevent cattle from escaping
	minetest.register_abm({
		nodenames = { gnameo },
		interval = 5,
		chance = 1,
		action = function(pos, old_node)
			minetest.swap_node(pos,
				{name = gnamec, param2 = old_node.param2}
			)
		end
	})

	-- Version of Sokomine's recipe using any wood, and dye:
	if cropo or pcolour ~= "light_blue" then
		minetest.register_craft({
			output = gnamec.." 2",
			recipe = {
				{ "default:steel_ingot", "group:wood", "default:steel_ingot" },
				{ "",                    "group:wood", "" },
				{ "",                    dyename, "" },
			}
		})
		-- Mushroom version for ethereal
		if ethshroom ~= "" then
			minetest.register_craft({
				output = gnamec .. " 2",
				recipe = {
					{ "default:steel_ingot", ethshroom, "default:steel_ingot" },
					{ "",                    ethshroom, "" },
					{ "",                    dyename, "" },
				}
			})
		end
		-- These fences can be repainted.
		minetest.register_craft({
			output = gnamec,
			recipe = {
				{ 'group:paint_gate2' },
				{ dyename },
			}
		})
	end

	minetest.register_craft({
		type = "fuel",
		recipe = gnamec,
		burntime = 8
	})
end

-- Now run this function for the list of colours:
for _, cols in pairs(dyelist) do

    local colour = cols[1]
    local label = cols[2]

    paintgateslong(colour, label)

end

--minetest.log("action", "[painted_fences] finished creating wide gates.")
