' This script changes a SKN to a proper BMF.
' Note: STRING * 1 = 1 byte, INTEGER = 2 bytes, LONG = 4 bytes, SINGLE = 4 bytes

DIM decv AS SINGLE
DIM intv AS LONG
DIM posno AS STRING * 1

' oneline$, partv$, i%

lineno% = 0
mode% = 0
no% = 0
fromlineno% = 0
tolineno% = 0

' Clean up first
'IF DIR$("x.bmf") THEN KILL "x.bmf"

' The names are hard-coded to prevent overwrites.
OPEN "x.skn" FOR INPUT AS #1
OPEN "x.bmf" FOR BINARY AS #2

DO UNTIL EOF(1)

  lineno% = lineno% + 1

  ' mesh name (precended by 1bit length)
  IF lineno% = 1 THEN
    INPUT #1, oneline$
    no% = LEN(oneline$)
    partv$ = MKI$(no%)
    posno = LEFT$(partv$,1)
    PUT #2, , posno
    PUT #2, , oneline$

  ' texture map (precended by 1bit length)
  ELSEIF lineno% = 2 THEN
    INPUT #1, oneline$
    no% = LEN(oneline$)
    partv$ = MKI$(no%)
    posno = LEFT$(partv$,1)
    PUT #2, , posno
    PUT #2, , oneline$

  ' joint number (long big-endian like all integers)
  ELSEIF lineno% = 3 THEN
    INPUT #1, oneline$
    intv = VAL(oneline$)
    PUT #2, , intv
    fromlineno% = 3 + 1
    tolineno% = 3 + intv
    mode% = 1

  ' joint names (precended by 1bit length)
  ELSEIF lineno% >= fromlineno% AND lineno% <= tolineno% AND mode% = 1 THEN
    INPUT #1, oneline$
    no% = LEN(oneline$)
    partv$ = MKI$(no%)
    posno = LEFT$(partv$,1)
    PUT #2, , posno
    PUT #2, , oneline$

  ' number of faces
  ELSEIF lineno% = tolineno% + 1 AND mode% = 1 THEN
    INPUT #1, oneline$
    intv = VAL(oneline$)
    PUT #2, , intv
    fromlineno% = tolineno% + 2
    tolineno% = tolineno% + 1 + intv
    mode% = 2

  ' faces, these need to be separated
  ELSEIF lineno% >= fromlineno% AND lineno% <= tolineno% AND mode% = 2 THEN
    INPUT #1, oneline$

    FOR I% = 1 TO 2
      no% = INSTR(oneline$, " ")
      partv$ = LEFT$(oneline$, no%)
      no% = no% + 1
      oneline$ = MID$(oneline$, no%)
      intv = VAL(partv$)
      PUT #2, , intv
    NEXT I%

    intv = VAL(oneline$)
    PUT #2, , intv

  ' number of joints again
  ELSEIF lineno% = tolineno% + 1 AND mode% = 2 THEN
    INPUT #1, oneline$
    intv = VAL(oneline$)
    PUT #2, , intv
    fromlineno% = tolineno% + 2
    tolineno% = tolineno% + 1 + intv
    mode% = 3

  ' joint assignments, these need to be separated
  ELSEIF lineno% >= fromlineno% AND lineno% <= tolineno% AND mode% = 3 THEN
    INPUT #1, oneline$

    FOR I% = 1 TO 4
      no% = INSTR(oneline$, " ")
      partv$ = LEFT$(oneline$, no%)
      no% = no% + 1
      oneline$ = MID$(oneline$, no%)
      intv = VAL(partv$)
      PUT #2, , intv
    NEXT I%

    intv = VAL(oneline$)
    PUT #2, , intv

  ' number of UVs
  ELSEIF lineno% = tolineno% + 1 AND mode% = 3 THEN
    INPUT #1, oneline$
    intv = VAL(oneline$)
    PUT #2, , intv
    fromlineno% = tolineno% + 2
    tolineno% = tolineno% + 1 + intv
    mode% = 4

  ' UVs, these need to be separated
  ELSEIF lineno% >= fromlineno% AND lineno% <= tolineno% AND mode% = 4 THEN
    INPUT #1, oneline$

    no% = INSTR(oneline$, " ")
    partv$ = LEFT$(oneline$, no%)
    no% = no% + 1
    oneline$ = MID$(oneline$, no%)
    decv = VAL(partv$)
    PUT #2, , decv

    decv = VAL(oneline$)
    PUT #2, , decv

  ' number of blends
  ELSEIF lineno% = tolineno% + 1 AND mode% = 4 THEN
    INPUT #1, oneline$
    intv = VAL(oneline$)
    PUT #2, , intv
    fromlineno% = tolineno% + 2
    tolineno% = tolineno% + 1 + intv
    mode% = 5

  ' blends, these need to be separated
  ELSEIF lineno% >= fromlineno% AND lineno% <= tolineno% AND mode% = 5 THEN
    INPUT #1, oneline$

    no% = INSTR(oneline$, " ")
    partv$ = LEFT$(oneline$, no%)
    no% = no% + 1
    oneline$ = MID$(oneline$, no%)

    ' remember to reverse them!!
    intv = VAL(oneline$)
    PUT #2, , intv

    intv = VAL(partv$)
    PUT #2, , intv

  ' number of vertices
  ELSEIF lineno% = tolineno% + 1 AND mode% = 5 THEN
    INPUT #1, oneline$
    intv = VAL(oneline$)
    PUT #2, , intv
    fromlineno% = tolineno% + 2
    tolineno% = tolineno% + 1 + intv
    mode% = 6

  ' vertices, these need to be separated
  ELSEIF lineno% >= fromlineno% AND lineno% <= tolineno% AND mode% = 6 THEN
    INPUT #1, oneline$
    
    FOR I% = 1 TO 5
    no% = INSTR(oneline$, " ")
    partv$ = LEFT$(oneline$, no%)
    no% = no% + 1
    oneline$ = MID$(oneline$, no%)
    decv = VAL(partv$)
    PUT #2, , decv
    NEXT I%

    decv = VAL(oneline$)
    PUT #2, , decv
    
  END IF

LOOP

CLOSE #1
CLOSE #2

' We should now have a BMF which can be renamed.

