' This script writes a PALT IFF and a SPR# IFF from a wallpaper BMP.

' This type I took from http://www.petesqbsite.com/sections/tutorials/tuts/loading_bmps.html
TYPE BMPHeaderType
	ID AS STRING * 2      'Should be "BM"
	size AS LONG          'Size of the data
	rr1 AS INTEGER        '
	rr2 AS INTEGER        '
	offset AS LONG        'Position of start of pixel data
	horz AS LONG          '
	Wid AS LONG           'Image width
	Hei AS LONG           'Image height
	planes AS INTEGER     '
	bpp AS INTEGER        'Should read 8 for a 256 colour image
	pakbyte AS LONG       '
	imagebytes AS LONG    'Width*Height
	xres AS LONG          '
	yres AS LONG          '
	colch AS LONG         '
	ic AS LONG            '
	pal AS STRING * 1024  'Stored as Blue, Green, Red, 0
END TYPE

DIM BmpHeader AS BMPHeaderType

DIM OneLine AS STRING * 150
DIM SpriteLine(1 TO 384) AS STRING * 150
DIM LastPos(1 TO 384) AS INTEGER
DIM FrameCount(1 TO 12) AS LONG
DIM ByteCount AS LONG
DIM Pixl AS INTEGER
DIM Colour AS STRING * 1
DIM Reversit AS STRING * 4

' Other vars: I%, J%, c%, word$, a$, r/g/b$,
' Sprite% LastLine% LineCount% Hei% Wid%
' Pixl1% Pixl2% Pixl3% NextPos% SegmentCount% RowCount%


' Clean up first
IF DIR$("PALT1537.IFF") THEN KILL "PALT1537.IFF"
IF DIR$("SPRITES.IFF") THEN KILL "SPRITES.IFF"
IF DIR$("TEMPSEG.BIN") THEN KILL "TEMPSEG.BIN"
FOR I% = 1 TO 12
  word$ = "SPRITE" + LTRIM$(STR$(I%)) + ".BIN"
  IF DIR$(word$) THEN KILL word$
  word$ = "FRAME" + LTRIM$(STR$(I%)) + ".BIN"
  IF DIR$(word$) THEN KILL word$
NEXT I%


' Main BMP is split into sprite files
OPEN "wallpap.bmp" FOR BINARY AS #1

  GET #1, , BmpHeader

' Note: a BMP is stored as a vertical flip

' First row (medium)
  OPEN "sprite5.bin" FOR BINARY LOCK WRITE AS #2
  OPEN "sprite6.bin" FOR BINARY LOCK WRITE AS #3
  OPEN "sprite7.bin" FOR BINARY LOCK WRITE AS #4
  OPEN "sprite8.bin" FOR BINARY LOCK WRITE AS #5

  FOR I% = 1 TO 384
  GET #1, , OneLine
  PUT #2, , OneLine
  GET #1, , OneLine
  PUT #3, , OneLine
  GET #1, , OneLine
  PUT #4, , OneLine
  GET #1, , OneLine
  PUT #5, , OneLine
  NEXT I%

  CLOSE #2
  CLOSE #3
  CLOSE #4
  CLOSE #5

' Second row (small)
  OPEN "sprite1.bin" FOR BINARY LOCK WRITE AS #2
  OPEN "sprite2.bin" FOR BINARY LOCK WRITE AS #3
  OPEN "sprite3.bin" FOR BINARY LOCK WRITE AS #4
  OPEN "sprite4.bin" FOR BINARY LOCK WRITE AS #5

  FOR I% = 1 TO 384
  GET #1, , OneLine
  PUT #2, , OneLine
  GET #1, , OneLine
  PUT #3, , OneLine
  GET #1, , OneLine
  PUT #4, , OneLine
  GET #1, , OneLine
  PUT #5, , OneLine
  NEXT I%

  CLOSE #2
  CLOSE #3
  CLOSE #4
  CLOSE #5

' Third row (big)
  OPEN "sprite9.bin" FOR BINARY LOCK WRITE AS #2
  OPEN "sprite10.bin" FOR BINARY LOCK WRITE AS #3
  OPEN "sprite11.bin" FOR BINARY LOCK WRITE AS #4
  OPEN "sprite12.bin" FOR BINARY LOCK WRITE AS #5

  FOR I% = 1 TO 384
  GET #1, , OneLine
  PUT #2, , OneLine
  GET #1, , OneLine
  PUT #3, , OneLine
  GET #1, , OneLine
  PUT #4, , OneLine
  GET #1, , OneLine
  PUT #5, , OneLine
  NEXT I%

  CLOSE #2
  CLOSE #3
  CLOSE #4
  CLOSE #5

CLOSE #1

' Properly export palette

OPEN "PALT1537.IFF" FOR BINARY LOCK WRITE AS #1

' Write IFF PALT block header (type/size always same)
' Note: Sims/IFFPencil is little-endian, QB is big-endian

words$ = "IFF FILE 2.5:TYPE FOLLOWED BY SIZE"
PUT #1, , words$
J% = 8192   ' 00 20
PUT #1, , J%
words$ = "JAMIE DOORNBOS & MAXIS 1"
PUT #1, , words$
J% = 0
PUT #1, , J%
J% = -25597     ' 924 (?)
PUT #1, , J%
words$ = "PALT"
PUT #1, , words$
J% = 0
PUT #1, , J%
J% = 23555      ' 860 (complete size)
PUT #1, , J%
J% = 262        ' 1537 (ID)
PUT #1, , J%
J% = 0
FOR I% = 1 TO 33
  PUT #1, , J%
NEXT I%

' Write BIN PALT header:
' 01 00 00 00, 00 01 00 00, 00 00 00 00, 00 00 00 00
' Each integer is a big-endian double byte
FOR I% = 1 TO 8
   J% = 0
   IF I% = 1 THEN J% = 1
   IF I% = 3 THEN J% = 256
   PUT #1, , J%
NEXT I%

' Write actual palette

a$ = BmpHeader.pal                ' Pal is stored in a 1024 character string

' Note: palette colours are stored in reverse (BGR)

FOR I% = 1 TO 1024
' Get colours in right order every fourth byte
   IF I% MOD 4 = 0 THEN

      b$ = MID$(a$, I% - 3, 1)  'blue
      g$ = MID$(a$, I% - 2, 1)  'green
      r$ = MID$(a$, I% - 1, 1)  'red

      Colour = r$
      PUT #1, , Colour
      Colour = g$
      PUT #1, , Colour
      Colour = b$
    PUT #1, , Colour

  END IF
NEXT I%

' End of palt iff
words$ = "rsmp"
PUT #1, , words$
J% = 0      ' 00 00
PUT #1, , J%
J% = 29184  ' 00 72
PUT #1, , J%
J% = 0      ' 00 00
PUT #1, , J%
J% = 4096   ' 00 10
PUT #1, , J%
FOR I% = 1 TO 36
  J% = 0      ' 00 00
  PUT #1, , J%
NEXT I%
words$ = "pmsr"
PUT #1, , words$
J% = 114    ' 72 00
PUT #1, , J%
J% = 0      ' 00 00
PUT #1, , J%
J% = 1      ' 01 00
PUT #1, , J%
J% = 0      ' 00 00
PUT #1, , J%
words$ = "TLAP"
PUT #1, , words$
J% = 1      ' 01 00
PUT #1, , J%
J% = 0      ' 00 00
PUT #1, , J%
J% = 64     ' 40 00
PUT #1, , J%
J% = 0      ' 00 00
PUT #1, , J%
J% = 1537   ' 01 06
PUT #1, , J%
J% = 0      ' 00 00
PUT #1, , J%
J% = -23808 ' 00 A3
PUT #1, , J%

CLOSE #1


' Write spriteN.bin to encoded frameN.bin

FOR Sprite% = 1 TO 12:

  ' Reopen each sprite file
  OPEN "SPRITE" + LTRIM$(STR$(Sprite%)) + ".BIN" FOR BINARY LOCK READ AS #1
  OPEN "FRAME" + LTRIM$(STR$(Sprite%)) + ".BIN" FOR BINARY LOCK WRITE AS #2

  ' Initialize variables
  LastLine% = 0
  FrameCount(Sprite%) = 0
  NextPos% = 0

  ' Read in spritefile to SpriteLine/LastPos, upside-down
  FOR I% = 1 TO 384

    GET #1, , SpriteLine(385 - I%)

    ' Get lastpos for line (and lastline)
    ' Misuse NextPos% for real width
    LastPos(385 - I%) = 0
    FOR J% = 1 TO 150 ' Lastpos stuck at last non-zero byte
      c% = ASC(MID$(SpriteLine(385 - I%), J%, 1))
      IF c% > 0 THEN LastPos(385 - I%) = J%
    NEXT J%
    IF NextPos% < LastPos(385 - I%) THEN NextPos% = LastPos(385 - I%)
    IF LastPos(385 - I%) <> 0 AND LastLine% = 0 THEN LastLine% = 385 - I%
  NEXT I%
  CLOSE #1

  ' For irregular sprites, Hei% would be Lastline% and
  ' Wid% the biggest LastPos[] (stored in Nextpos%)
  ' Wallpapers can NEVER be irregular

  ' Determine width/height for regular frame
  IF Sprite% = 1 THEN
  ' 43 00 10 00 x2
      Hei% = 67
      Wid% = 16
  ELSEIF Sprite% = 2 THEN
  ' 44 00 10 00 x2
      Hei% = 68
      Wid% = 16
  ELSEIF Sprite% = 3 THEN
  ' 3C 00 20 00
      Hei% = 60
      Wid% = 32
  ELSEIF Sprite% = 4 THEN
  ' 3A 00 04 00
      Hei% = 58
      Wid% = 4
  ELSEIF Sprite% = 5 THEN
  ' 87 00 20 00 x2
      Hei% = 135
      Wid% = 32
  ELSEIF Sprite% = 6 THEN
  ' 88 00 20 00 x2
      Hei% = 136
      Wid% = 32
  ELSEIF Sprite% = 7 THEN
  ' 78 00 40 00
      Hei% = 120
      Wid% = 64
  ELSEIF Sprite% = 8 THEN
  ' 74 00 08 00
      Hei% = 116
      Wid% = 8
  ELSEIF Sprite% = 9 THEN
  ' 0F 01 40 00
      Hei% = 271
      Wid% = 64
  ELSEIF Sprite% = 10 THEN
  ' 10 01 40 00
      Hei% = 272
      Wid% = 64
  ELSEIF Sprite% = 11 THEN
  ' F0 00 80 00
      Hei% = 240
      Wid% = 132
  ELSEIF Sprite% = 12 THEN
  ' 00 E8 00 10
      Hei% = 232
      Wid% = 16
  END IF

  ' Trim values
  IF LastLine% > Hei% THEN LastLine% = Hei%
  ' For regular wallpaper size with transparent graphic (doesn't work anyway)
  LastLine% = Hei%
'  IF Hei% > Lastline% THEN Hei% = Lastline% - commented out for wallpaper
'  IF NextPos% < Wid% THEN Wid% = NextPos%
  FOR I% = 1 TO 384
    IF LastPos(I%) > Wid% THEN LastPos(I%) = Wid%
  NEXT I%

  ' Write frame header, 5 double bytes:
  ' 4* 00, double-byte height = Hei%, double-byte width = Wid%, 2* 00
  ' 00 00 00 00, HH HH WW WW, 00 00
  ' Each integer is a big-endian double byte
  FOR I% = 1 TO 5
    J% = 0
    IF I% = 3 THEN J% = Hei%
    IF I% = 4 THEN J% = Wid%
    PUT #2, , J%
  NEXT I%

  ' Encode spritelines to frame
  LineCount% = 0
  ByteCount = 10 ' Header
  SegmentCount% = 0
  RowCount% = 0
  NextPos% = 0

  FOR I% = 1 TO Hei%

    ' Zero line: add line count
    IF LastPos(I%) = 0 THEN
      LineCount% = LineCount% + 1
    ' Non-zero line: make zero-line row header if linecount>0
    ELSEIF LastPos(I%) > 0 AND LineCount% > 0 THEN
      Colour = CHR$(9)
      PUT #2, , Colour
      Colour = CHR$(LineCount%)
      PUT #2, , Colour
      ByteCount = ByteCount + 2
      LineCount% = 0
    END IF

    ' The non-zero lines (compress per line)
    IF LastPos(I%) > 0 THEN
      SegmentCount% = 0
      RowCount% = 0
      NextPos% = 0
      OPEN "tempseg.bin" FOR BINARY LOCK WRITE AS #3

      FOR J% = 1 TO LastPos(I%)
	' Process from this position, RowCount
	IF J% >= NextPos% THEN

	  Colour = MID$(SpriteLine(I%), J%, 1)
	  Pixl = ASC(Colour)
	  IF J% + 1 > LastPos(I%) THEN
	    Pixl1% = 0
	  ELSE
	    Pixl1% = ASC(MID$(SpriteLine(I%), J% + 1, 1))
	  END IF
	  IF J% + 2 > LastPos(I%) THEN
	    Pixl2% = 0
	  ELSE
	    Pixl2% = ASC(MID$(SpriteLine(I%), J% + 2, 1))
	  END IF
	  IF J% + 3 > LastPos(I%) THEN
	    Pixl3% = 0
	  ELSE
	    Pixl3% = ASC(MID$(SpriteLine(I%), J% + 3, 1))
	  END IF

	  ' Colour zero
	  IF Pixl = 0 THEN
	    SegmentCount% = 1
	    NextPos% = 0
	    ' Loop for first non-zero byte
	    WHILE Pixl = 0
	      NextPos% = NextPos% + 1
	      ' Skip before end
	      IF J% + NextPos% > LastPos(I%) THEN
		Pixl = 1
	      ELSE
		Pixl = ASC(MID$(SpriteLine(I%), J% + NextPos%, 1))
	      END IF
	      ' If pixel OK then add
	      IF Pixl = 0 THEN SegmentCount% = SegmentCount% + 1
	    WEND
	    ' Write segment header/count to tempfile
	    Colour = CHR$(1)
	    PUT #3, , Colour
	    Colour = CHR$(SegmentCount%)
	    PUT #3, , Colour
	    RowCount% = RowCount% + 2
	    ' Continue at nextpos
	    NextPos% = J% + SegmentCount%

	  ' RLE: at least 4x same colour (because RLE is 4 bytes)
	  ELSEIF Pixl = Pixl1% AND Pixl = Pixl2% AND Pixl = Pixl3% THEN
	    SegmentCount% = 1
	    NextPos% = 0
	    ' Loop for first diff-colour byte
	    WHILE ASC(Colour) = Pixl
	      NextPos% = NextPos% + 1
	      ' Skip before end
	      IF J% + NextPos% > LastPos(I%) THEN
		Colour = CHR$(0)
	      ELSE
		Colour = MID$(SpriteLine(I%), J% + NextPos%, 1)
	      END IF
	      IF ASC(Colour) = Pixl THEN SegmentCount% = SegmentCount% + 1
	    WEND
	    ' Write segment header/count and 2x palette index to tempfile
	    Colour = CHR$(2)
	    PUT #3, , Colour
	    Colour = CHR$(SegmentCount%)
	    PUT #3, , Colour
	    Colour = CHR$(Pixl)
	    PUT #3, , Colour
	    Colour = CHR$(Pixl)
	    PUT #3, , Colour
	    RowCount% = RowCount% + 4
	    ' Continue at nextpos
	    NextPos% = J% + SegmentCount%

	  ' Paletted colour
	  ELSEIF Pixl <> 0 THEN
	    NextPos% = 0
	    SegmentCount% = 1
	    ' Then loop for first zero or 3 same bytes
	    WHILE Pixl <> 0
	      NextPos% = NextPos% + 1
	      ' Skip before end
	      IF J% + NextPos% > LastPos(I%) THEN
		Pixl = 0
	      ELSE
		Colour = MID$(SpriteLine(I%), J% + NextPos%, 1)
		Pixl = ASC(Colour)
		Pixl1% = ASC(MID$(SpriteLine(I%), J% + NextPos% + 1, 1))
		Pixl2% = ASC(MID$(SpriteLine(I%), J% + NextPos% + 2, 1))
		Pixl3% = ASC(MID$(SpriteLine(I%), J% + NextPos% + 3, 1))
		IF J% + NextPos% + 1 > LastPos(I%) THEN Pixl1% = 0
		IF J% + NextPos% + 2 > LastPos(I%) THEN Pixl2% = 0
		IF J% + NextPos% + 3 > LastPos(I%) THEN Pixl3% = 0
	      END IF
	      IF Pixl <> 0 AND Pixl = Pixl1% AND Pixl = Pixl2% AND Pixl = Pixl3% THEN Pixl = 0
	      ' Pixel = 0 if 0, 4same or past end of line
	      IF Pixl <> 0 THEN SegmentCount% = SegmentCount% + 1
	    WEND
	    ' Write segment header/count to tempfile
	    Colour = CHR$(3)
	    PUT #3, , Colour
	    Colour = CHR$(SegmentCount%)
	    PUT #3, , Colour
	    RowCount% = RowCount% + SegmentCount% + 2
	    ' Range has been established, now pixels are exported
	    FOR NextPos% = J% TO J% + SegmentCount% - 1
	      Colour = MID$(SpriteLine(I%), NextPos%, 1)
	      PUT #3, , Colour
	    NEXT NextPos%
	    ' If segment count uneven, write padder 00
	    IF SegmentCount% MOD 2 <> 0 THEN
	      Colour = CHR$(0)
	      PUT #3, , Colour
	      RowCount% = RowCount% + 1
	    END IF
	    NextPos% = J% + SegmentCount%

	  END IF   ' If Pixl
	END IF   ' End Process from this position
      NEXT J%

      CLOSE #3
      ' Write row header
      Colour = CHR$(4)
      PUT #2, , Colour
      Colour = CHR$(RowCount% + 2)  ' Include header bytes
      PUT #2, , Colour
      ByteCount = ByteCount + 2
      OPEN "tempseg.bin" FOR BINARY LOCK READ AS #3
      ' RowCount% should be the size of tempseg.bin (row without header)
      FOR J% = 1 TO RowCount%
	GET #3, , Colour
	PUT #2, , Colour
      NEXT J%
      CLOSE #3
      ByteCount = ByteCount + RowCount%
      KILL "tempseg.bin"

    END IF  ' End of nonzero line

  NEXT I% ' Encode all lines in 1 frame

  J% = 5
  PUT #2, , J%
  CLOSE #2
  FrameCount(Sprite%) = ByteCount + 2
  ByteCount = 0
  ' The frame is now encoded.
  KILL "SPRITE" + LTRIM$(STR$(Sprite%)) + ".BIN"

NEXT Sprite%


' Loading SPR#n.bins had proven unreliable, so best write an IFF.

OPEN "SPRITES.IFF" FOR BINARY LOCK WRITE AS #1

words$ = "IFF FILE 2.5:TYPE FOLLOWED BY SIZE"
PUT #1, , words$
J% = 8192   ' 00 20
PUT #1, , J%
words$ = "JAMIE DOORNBOS & MAXIS 1"
PUT #1, , words$

ByteCount = 140 + 76 + 76 + 28 + 28 + 28  ' (frame) headers
FOR I% = 1 TO 12
  ByteCount = ByteCount + FrameCount(I%)
NEXT I%

' Reverse LONG value with string var Reversit
OPEN "tempseg.bin" FOR BINARY LOCK WRITE AS #2
PUT #2, , ByteCount
CLOSE #2

OPEN "tempseg.bin" FOR BINARY LOCK READ AS #2
GET #2, , Reversit
CLOSE #2
KILL "tempseg.bin"

FOR I% = 4 TO 1 STEP -1
  Colour = MID$(Reversit, I%, 1)
  PUT #1, , Colour
NEXT I%

' Begin of first SPR#
words$ = "SPR#"
PUT #1, , words$

ByteCount = 76 + 28
FOR I% = 1 TO 4
  ByteCount = ByteCount + FrameCount(I%)
NEXT I%

' Reverse LONG value with string var Reversit
OPEN "tempseg.bin" FOR BINARY LOCK WRITE AS #2
PUT #2, , ByteCount
CLOSE #2

OPEN "tempseg.bin" FOR BINARY LOCK READ AS #2
GET #2, , Reversit
CLOSE #2
KILL "tempseg.bin"

FOR I% = 4 TO 1 STEP -1
  Colour = MID$(Reversit, I%, 1)
  PUT #1, , Colour
NEXT I%

' ID of first sprite, reversed, + 16 (00 01 00 10)
Reversit = CHR$(0) + CHR$(1) + CHR$(0) + CHR$(16) ' = hex 10
PUT #1, , Reversit

word$ = "smallsprite"
PUT #1, , word$

FOR I% = 1 TO 53
  Colour = CHR$(0)
  PUT #1, , Colour
NEXT I%

' Here starts the first frame header (small zoom)

ByteCount = 504
PUT #1, , ByteCount
ByteCount = 4
PUT #1, , ByteCount
ByteCount = 1537
PUT #1, , ByteCount
ByteCount = 28
PUT #1, , ByteCount
ByteCount = 28 + FrameCount(1)
PUT #1, , ByteCount
ByteCount = 28 + FrameCount(1) + FrameCount(2)
PUT #1, , ByteCount
ByteCount = 28 + FrameCount(1) + FrameCount(2) + FrameCount(3)
PUT #1, , ByteCount

FOR NextPos% = 1 TO 4:
  ' Reopen each frame file
  OPEN "FRAME" + LTRIM$(STR$(NextPos%)) + ".BIN" FOR BINARY LOCK READ AS #2
  FOR ByteCount = 1 TO FrameCount(NextPos%)
    GET #2, , Colour
    PUT #1, , Colour
  NEXT ByteCount
  CLOSE #2
NEXT NextPos%

' Intermediate SPR# header
words$ = "SPR#"
PUT #1, , words$

ByteCount = 76 + 28
FOR I% = 5 TO 8
  ByteCount = ByteCount + FrameCount(I%)
NEXT I%

' Reverse LONG value with string var Reversit
OPEN "tempseg.bin" FOR BINARY LOCK WRITE AS #2
PUT #2, , ByteCount
CLOSE #2

OPEN "tempseg.bin" FOR BINARY LOCK READ AS #2
GET #2, , Reversit
CLOSE #2
KILL "tempseg.bin"

FOR I% = 4 TO 1 STEP -1
  Colour = MID$(Reversit, I%, 1)
  PUT #1, , Colour
NEXT I%

' ID of second sprite, reversed, + 16 (07 01 00 10)
Reversit = CHR$(7) + CHR$(1) + CHR$(0) + CHR$(16) ' = hex 10
PUT #1, , Reversit

word$ = "1:2(1793)"
PUT #1, , word$

FOR I% = 1 TO 55
  Colour = CHR$(0)
  PUT #1, , Colour
NEXT I%

' This is the second frame header (medium zoom)

ByteCount = 504
PUT #1, , ByteCount
ByteCount = 4
PUT #1, , ByteCount
ByteCount = 1537
PUT #1, , ByteCount
ByteCount = 28
PUT #1, , ByteCount
ByteCount = 28 + FrameCount(5)
PUT #1, , ByteCount
ByteCount = 28 + FrameCount(5) + FrameCount(6)
PUT #1, , ByteCount
ByteCount = 28 + FrameCount(5) + FrameCount(6) + FrameCount(7)
PUT #1, , ByteCount

FOR NextPos% = 5 TO 8:
  ' Reopen each frame file
  OPEN "FRAME" + LTRIM$(STR$(NextPos%)) + ".BIN" FOR BINARY LOCK READ AS #2
  FOR ByteCount = 1 TO FrameCount(NextPos%)
    GET #2, , Colour
    PUT #1, , Colour
  NEXT ByteCount
  CLOSE #2
NEXT NextPos%

' Intermediate SPR# header
words$ = "SPR#"
PUT #1, , words$

ByteCount = 76 + 28
FOR I% = 9 TO 12
  ByteCount = ByteCount + FrameCount(I%)
NEXT I%

' Reverse LONG value with string var Reversit
OPEN "tempseg.bin" FOR BINARY LOCK WRITE AS #2
PUT #2, , ByteCount
CLOSE #2

OPEN "tempseg.bin" FOR BINARY LOCK READ AS #2
GET #2, , Reversit
CLOSE #2
KILL "tempseg.bin"

FOR I% = 4 TO 1 STEP -1
  Colour = MID$(Reversit, I%, 1)
  PUT #1, , Colour
NEXT I%

' ID of second sprite, reversed, + 16 (08 01 00 10)
Reversit = CHR$(8) + CHR$(1) + CHR$(0) + CHR$(16) ' = hex 10
PUT #1, , Reversit

word$ = "1:3(2049)"
PUT #1, , word$

FOR I% = 1 TO 55
  Colour = CHR$(0)
  PUT #1, , Colour
NEXT I%

' This is the third frame header (large zoom)

ByteCount = 504
PUT #1, , ByteCount
ByteCount = 4
PUT #1, , ByteCount
ByteCount = 1537
PUT #1, , ByteCount
ByteCount = 28
PUT #1, , ByteCount
ByteCount = 28 + FrameCount(9)
PUT #1, , ByteCount
ByteCount = 28 + FrameCount(9) + FrameCount(10)
PUT #1, , ByteCount
ByteCount = 28 + FrameCount(9) + FrameCount(10) + FrameCount(11)
PUT #1, , ByteCount

FOR NextPos% = 9 TO 12:
  ' Reopen each frame file
  OPEN "FRAME" + LTRIM$(STR$(NextPos%)) + ".BIN" FOR BINARY LOCK READ AS #2
  FOR ByteCount = 1 TO FrameCount(NextPos%)
    GET #2, , Colour
    PUT #1, , Colour
  NEXT ByteCount
  CLOSE #2
NEXT NextPos%

' rsmp block
word$ = "rsmp"
PUT #1, , word$

' Total length of footer, reversed; for wallpapers, 160
ByteCount = 160

' Reverse LONG value with string var Reversit
OPEN "tempseg.bin" FOR BINARY LOCK WRITE AS #2
PUT #2, , ByteCount
CLOSE #2

OPEN "tempseg.bin" FOR BINARY LOCK READ AS #2
GET #2, , Reversit
CLOSE #2
KILL "tempseg.bin"

FOR I% = 4 TO 1 STEP -1
  Colour = MID$(Reversit, I%, 1)
  PUT #1, , Colour
NEXT I%

' 76 bytes, 4th = 10
FOR I% = 1 TO 76
   IF I% = 4 THEN Colour = CHR$(16) ELSE Colour = CHR$(0)
   PUT #1, , Colour
NEXT I%

word$ = "pmsr"
PUT #1, , word$

' Footer size, the right way round, followed by 1
ByteCount = 160
PUT #1, , ByteCount
ByteCount = 1
PUT #1, , ByteCount

' #RPS

word$ = "#RPS"
PUT #1, , word$
ByteCount = 3  ' number of sprite strings
PUT #1, , ByteCount
ByteCount = 64  ' fixed value
PUT #1, , ByteCount

' ID of first sprite + 16 + string + 00
J% = 1
PUT #1, , J%
J% = 16
PUT #1, , J%
word$ = "smallsprite"
PUT #1, , word$
Colour = CHR$(0)
PUT #1, , Colour

' Length first SPR# header and frame
ByteCount = 140 + 28
FOR I% = 1 TO 4
   ByteCount = ByteCount + FrameCount(I%)
NEXT I%
PUT #1, , ByteCount

' ID of second sprite + 16 + string + 00
J% = 1793
PUT #1, , J%
J% = 16
PUT #1, , J%
word$ = "1:2(1793)"
PUT #1, , word$
Colour = CHR$(0)
PUT #1, , Colour

' Length first SPR# header and frame and 2nd header/frame
ByteCount = 140 + 28 + 76 + 28
FOR I% = 1 TO 8
   ByteCount = ByteCount + FrameCount(I%)
NEXT I%
PUT #1, , ByteCount

' ID of third sprite + 16 + string + 00
J% = 2049
PUT #1, , J%
J% = 16
PUT #1, , J%
word$ = "1:3(2049)"
PUT #1, , word$
Colour = CHR$(0)
PUT #1, , Colour

CLOSE #1

' Delete tempframes
FOR J% = 1 TO 12:
  KILL "FRAME" + LTRIM$(STR$(J%)) + ".BIN"
NEXT J%

